/*
 * Decompiled with CFR 0.152.
 */
package com.github.bartimaeusnek.crossmod.galacticgreg;

import bloodasp.galacticgreg.GT_Worldgen_GT_Ore_Layer_Space;
import bloodasp.galacticgreg.GT_Worldgen_GT_Ore_SmallPieces_Space;
import bloodasp.galacticgreg.GalacticGreg;
import bloodasp.galacticgreg.api.ModDimensionDef;
import bloodasp.galacticgreg.bartworks.BW_Worldgen_Ore_Layer_Space;
import bloodasp.galacticgreg.bartworks.BW_Worldgen_Ore_SmallOre_Space;
import bloodasp.galacticgreg.registry.GalacticGregRegistry;
import com.github.bartimaeusnek.bartworks.common.configs.ConfigHandler;
import com.github.bartimaeusnek.bartworks.system.material.Werkstoff;
import com.github.bartimaeusnek.bartworks.system.material.WerkstoffLoader;
import com.github.bartimaeusnek.bartworks.system.oregen.BW_OreLayer;
import com.github.bartimaeusnek.bartworks.system.oregen.BW_WorldGenRoss128b;
import com.github.bartimaeusnek.bartworks.system.oregen.BW_WorldGenRoss128ba;
import com.github.bartimaeusnek.bartworks.util.Pair;
import com.google.common.collect.ArrayListMultimap;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.interfaces.ISubTagContainer;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GT_LanguageManager;
import gregtech.common.GT_Worldgen_GT_Ore_Layer;
import gregtech.common.GT_Worldgen_GT_Ore_SmallPieces;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_DrillerBase;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.fluids.FluidStack;

public abstract class GT_TileEntity_VoidMiner_Base
extends GT_MetaTileEntity_DrillerBase {
    private static ArrayListMultimap<Integer, Pair<Pair<Integer, Boolean>, Float>> extraDropsDimMap = ArrayListMultimap.create();
    private static FluidStack[] NOBLE_GASSES = new FluidStack[]{WerkstoffLoader.Neon.getFluidOrGas(1), WerkstoffLoader.Krypton.getFluidOrGas(1), WerkstoffLoader.Xenon.getFluidOrGas(1), WerkstoffLoader.Oganesson.getFluidOrGas(1)};
    private HashMap<Pair<Integer, Boolean>, Float> dropmap = null;
    private float totalWeight;
    private int multiplier = 1;
    protected byte TIER_MULTIPLIER;

    public static void addMatierialToDimensionList(int DimensionID, ISubTagContainer Material2, float weight) {
        if (Material2 instanceof Materials) {
            GT_TileEntity_VoidMiner_Base.getExtraDropsDimMap().put((Object)DimensionID, new Pair<Pair<Integer, Boolean>, Float>(new Pair<Integer, Boolean>(((Materials)Material2).mMetaItemSubID, false), Float.valueOf(weight)));
        } else if (Material2 instanceof Werkstoff) {
            GT_TileEntity_VoidMiner_Base.getExtraDropsDimMap().put((Object)DimensionID, new Pair<Pair<Integer, Boolean>, Float>(new Pair<Integer, Boolean>(Integer.valueOf(((Werkstoff)Material2).getmID()), true), Float.valueOf(weight)));
        }
    }

    public GT_TileEntity_VoidMiner_Base(int aID, String aName, String aNameRegional, int tier) {
        super(aID, aName, aNameRegional);
        this.TIER_MULTIPLIER = (byte)Math.max(tier, 1);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.setByte("TIER_MULTIPLIER", this.TIER_MULTIPLIER);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.TIER_MULTIPLIER = aNBT.getByte("TIER_MULTIPLIER");
    }

    public GT_TileEntity_VoidMiner_Base(String aName, int tier) {
        super(aName);
        this.TIER_MULTIPLIER = (byte)tier;
    }

    protected int getMinTier() {
        return this.TIER_MULTIPLIER + 5;
    }

    protected boolean checkHatches() {
        return true;
    }

    protected void setElectricityStats() {
        try {
            this.mEUt = this.isPickingPipes ? 60 : Math.toIntExact(GT_Values.V[this.getMinTier()]);
        }
        catch (ArithmeticException e) {
            e.printStackTrace();
            this.mEUt = 0x7FFFFFF8;
        }
        this.mOutputItems = new ItemStack[0];
        this.mProgresstime = 0;
        this.mMaxProgresstime = 10;
        this.mEfficiency = this.getCurrentEfficiency(null);
        this.mEfficiencyIncrease = 10000;
        this.mEUt = this.mEUt > 0 ? -this.mEUt : this.mEUt;
    }

    protected boolean workingAtBottom(ItemStack aStack, int xDrill, int yDrill, int zDrill, int xPipe, int zPipe, int yHead, int oldYHead) {
        this.makeDropMap();
        this.handleFluidConsumption();
        this.handleOutputs();
        return true;
    }

    public String[] getDescription() {
        String casingName = GT_LanguageManager.getTranslation((String)GT_LanguageManager.getTranslateableItemStackName((ItemStack)this.getCasingBlockItem().get(1L, new Object[0])));
        return new String[]{"Controller Block for the Void Miner " + GT_Values.VN[this.getMinTier()], "Size(WxHxD): 3x7x3", "Controller (Front middle at bottom)", "3x1x3 Base of " + casingName, "1x3x1 " + casingName + " pillar (Center of base)", "1x3x1 " + this.getFrameMaterial().mName + " Frame Boxes (Each pillar side and on top)", "1x Output Bus (One of base casings)", "Optional: 0+ Input Hatch (One of base casings)", "1x Maintenance Hatch (One of base casings)", "1x " + GT_Values.VN[this.getMinTier()] + "+ Energy Hatch (Any bottom layer casing)", "Consumes " + GT_Values.V[this.getMinTier()] + "EU/t", "Can be supplied with 2L/s of Neon(x4), Krypton(x8), Xenon(x16) or Oganesson(x64)", "for higher outputs.", "Will output " + 2 * this.TIER_MULTIPLIER + " Ores per Second depending on the Dimension it is build in", StatCollector.translateToLocal((String)"tooltip.bw.1.name") + "\u00a72" + " BartWorks"};
    }

    public static ArrayListMultimap<Integer, Pair<Pair<Integer, Boolean>, Float>> getExtraDropsDimMap() {
        return extraDropsDimMap;
    }

    private Predicate<GT_Worldgen_GT_Ore_Layer> makeOreLayerPredicate() {
        switch (this.getBaseMetaTileEntity().getWorld().provider.dimensionId) {
            case -1: {
                return gt_worldgen -> gt_worldgen.mNether;
            }
            case 0: {
                return gt_worldgen -> gt_worldgen.mOverworld;
            }
            case 1: {
                return gt_worldgen -> gt_worldgen.mEnd || gt_worldgen.mEndAsteroid;
            }
        }
        throw new IllegalStateException();
    }

    private Predicate<GT_Worldgen_GT_Ore_SmallPieces> makeSmallOresPredicate() {
        switch (this.getBaseMetaTileEntity().getWorld().provider.dimensionId) {
            case -1: {
                return gt_worldgen -> gt_worldgen.mNether;
            }
            case 0: {
                return gt_worldgen -> gt_worldgen.mOverworld;
            }
            case 1: {
                return gt_worldgen -> gt_worldgen.mEnd;
            }
        }
        throw new IllegalStateException();
    }

    private void getDropsVanillaVeins(Predicate<GT_Worldgen_GT_Ore_Layer> oreLayerPredicate) {
        GT_Worldgen_GT_Ore_Layer.sList.stream().filter(gt_worldgen -> gt_worldgen.mEnabled && oreLayerPredicate.test((GT_Worldgen_GT_Ore_Layer)gt_worldgen)).forEach(element -> {
            this.dropmap.put(new Pair<Integer, Boolean>(Integer.valueOf(element.mPrimaryMeta), false), Float.valueOf(element.mWeight));
            this.dropmap.put(new Pair<Integer, Boolean>(Integer.valueOf(element.mSecondaryMeta), false), Float.valueOf(element.mWeight));
            this.dropmap.put(new Pair<Integer, Boolean>(Integer.valueOf(element.mSporadicMeta), false), Float.valueOf((float)element.mWeight / 8.0f));
            this.dropmap.put(new Pair<Integer, Boolean>(Integer.valueOf(element.mBetweenMeta), false), Float.valueOf((float)element.mWeight / 8.0f));
        });
    }

    private void getDropsVanillaSmallOres(Predicate<GT_Worldgen_GT_Ore_SmallPieces> smallOresPredicate) {
        GT_Worldgen_GT_Ore_SmallPieces.sList.stream().filter(gt_worldgen -> gt_worldgen.mEnabled && smallOresPredicate.test((GT_Worldgen_GT_Ore_SmallPieces)gt_worldgen)).forEach(element -> this.dropmap.put(new Pair<Integer, Boolean>(Integer.valueOf(element.mMeta), false), Float.valueOf(element.mAmount)));
    }

    private void getDropMapVanilla() {
        this.getDropsVanillaVeins(this.makeOreLayerPredicate());
        this.getDropsVanillaSmallOres(this.makeSmallOresPredicate());
    }

    private void getDropMapSpace(ModDimensionDef finalDef) {
        this.getDropsOreVeinsSpace(finalDef);
        this.getDropsSmallOreSpace(finalDef);
    }

    private void getDropsOreVeinsSpace(ModDimensionDef finalDef) {
        Set<Object> space = GalacticGreg.oreVeinWorldgenList.stream().filter(gt_worldgen -> gt_worldgen.mEnabled && gt_worldgen instanceof GT_Worldgen_GT_Ore_Layer_Space && ((GT_Worldgen_GT_Ore_Layer_Space)gt_worldgen).isEnabledForDim(finalDef)).collect(Collectors.toSet());
        space.forEach(element -> {
            this.dropmap.put(new Pair<Integer, Boolean>(Integer.valueOf(((GT_Worldgen_GT_Ore_Layer_Space)element).mPrimaryMeta), false), Float.valueOf(((GT_Worldgen_GT_Ore_Layer_Space)element).mWeight));
            this.dropmap.put(new Pair<Integer, Boolean>(Integer.valueOf(((GT_Worldgen_GT_Ore_Layer_Space)element).mSecondaryMeta), false), Float.valueOf(((GT_Worldgen_GT_Ore_Layer_Space)element).mWeight));
            this.dropmap.put(new Pair<Integer, Boolean>(Integer.valueOf(((GT_Worldgen_GT_Ore_Layer_Space)element).mSporadicMeta), false), Float.valueOf((float)((GT_Worldgen_GT_Ore_Layer_Space)element).mWeight / 8.0f));
            this.dropmap.put(new Pair<Integer, Boolean>(Integer.valueOf(((GT_Worldgen_GT_Ore_Layer_Space)element).mBetweenMeta), false), Float.valueOf((float)((GT_Worldgen_GT_Ore_Layer_Space)element).mWeight / 8.0f));
        });
    }

    private void getDropsSmallOreSpace(ModDimensionDef finalDef) {
        Set<Object> space = GalacticGreg.smallOreWorldgenList.stream().filter(gt_worldgen -> gt_worldgen.mEnabled && gt_worldgen instanceof GT_Worldgen_GT_Ore_SmallPieces_Space && ((GT_Worldgen_GT_Ore_SmallPieces_Space)gt_worldgen).isEnabledForDim(finalDef)).collect(Collectors.toSet());
        space.forEach(element -> this.dropmap.put(new Pair<Integer, Boolean>(Integer.valueOf(((GT_Worldgen_GT_Ore_SmallPieces_Space)element).mMeta), false), Float.valueOf(((GT_Worldgen_GT_Ore_SmallPieces_Space)element).mAmount)));
    }

    private Pair<Integer, Boolean> getOreDamage() {
        Map.Entry<Pair<Integer, Boolean>, Float> entry;
        int curentWeight = 0;
        block0: while (true) {
            int randomeint = Math.abs(XSTR.XSTR_INSTANCE.nextInt((int)Math.ceil(this.totalWeight)));
            Iterator<Map.Entry<Pair<Integer, Boolean>, Float>> iterator = this.dropmap.entrySet().iterator();
            do {
                if (!iterator.hasNext()) continue block0;
            } while (randomeint >= (curentWeight = (int)((float)curentWeight + (entry = iterator.next()).getValue().floatValue())));
            break;
        }
        return entry.getKey();
    }

    private FluidStack getNobleGasInputAndSetMultiplier() {
        for (FluidStack s : this.getStoredFluids()) {
            for (int i = 0; i < NOBLE_GASSES.length; ++i) {
                FluidStack ng = NOBLE_GASSES[i];
                if (!ng.isFluidEqual(s)) continue;
                this.multiplier = this.TIER_MULTIPLIER * (2 << (i == NOBLE_GASSES.length - 1 ? i + 2 : i + 1));
                return s;
            }
        }
        return null;
    }

    private boolean consumeNobleGas(FluidStack gasToConsume) {
        for (FluidStack s : this.getStoredFluids()) {
            if (!s.isFluidEqual(gasToConsume) || s.amount < 1) continue;
            --s.amount;
            this.updateSlots();
            return true;
        }
        return false;
    }

    private void handleFluidConsumption() {
        FluidStack storedNobleGas = this.getNobleGasInputAndSetMultiplier();
        if (storedNobleGas == null || !this.consumeNobleGas(storedNobleGas)) {
            this.multiplier = this.TIER_MULTIPLIER;
        }
    }

    private void getDropMapBartworks(ModDimensionDef finalDef, int aID) {
        Consumer<BW_OreLayer> addToList = this.makeAddToList();
        if (aID == ConfigHandler.ross128BID) {
            BW_WorldGenRoss128b.sList.forEach(addToList);
        } else if (aID == ConfigHandler.ross128BAID) {
            BW_WorldGenRoss128ba.sList.forEach(addToList);
        } else {
            this.addOresVeinsBartworks(finalDef, addToList);
            this.addSmallOresBartworks(finalDef);
        }
    }

    private Consumer<BW_OreLayer> makeAddToList() {
        return element -> {
            List<Pair<Integer, Boolean>> data = element.getStacksRawData();
            for (int i = 0; i < data.size(); ++i) {
                if (i < data.size() - 1) {
                    this.dropmap.put(data.get(i), Float.valueOf(element.mWeight));
                    continue;
                }
                this.dropmap.put(data.get(i), Float.valueOf((float)element.mWeight / 8.0f));
            }
        };
    }

    private ModDimensionDef makeModDimDef() {
        return GalacticGregRegistry.getModContainers().stream().flatMap(modContainer -> modContainer.getDimensionList().stream()).filter(modDimensionDef -> modDimensionDef.getChunkProviderName().equals(((ChunkProviderServer)this.getBaseMetaTileEntity().getWorld().getChunkProvider()).currentChunkProvider.getClass().getName())).findFirst().orElse(null);
    }

    private void addOresVeinsBartworks(ModDimensionDef finalDef, Consumer<BW_OreLayer> addToList) {
        try {
            Set<BW_OreLayer> space = GalacticGreg.oreVeinWorldgenList.stream().filter(gt_worldgen -> gt_worldgen.mEnabled && gt_worldgen instanceof BW_Worldgen_Ore_Layer_Space && ((BW_Worldgen_Ore_Layer_Space)gt_worldgen).isEnabledForDim(finalDef)).collect(Collectors.toSet());
            space.forEach(addToList);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void addSmallOresBartworks(ModDimensionDef finalDef) {
        try {
            Set<Object> space = GalacticGreg.smallOreWorldgenList.stream().filter(gt_worldgen -> gt_worldgen.mEnabled && gt_worldgen instanceof BW_Worldgen_Ore_SmallOre_Space && ((BW_Worldgen_Ore_SmallOre_Space)gt_worldgen).isEnabledForDim(finalDef)).collect(Collectors.toSet());
            space.forEach(element -> this.dropmap.put(new Pair<Integer, Boolean>(((BW_Worldgen_Ore_SmallOre_Space)element).mPrimaryMeta, ((BW_Worldgen_Ore_SmallOre_Space)element).bwOres != 0), Float.valueOf(((BW_Worldgen_Ore_SmallOre_Space)element).mDensity)));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void handleExtraDrops(int id) {
        Optional.ofNullable(GT_TileEntity_VoidMiner_Base.getExtraDropsDimMap().get((Object)id)).ifPresent(e -> e.forEach(f -> this.dropmap.put((Pair<Integer, Boolean>)f.getKey(), (Float)f.getValue())));
    }

    private void calculateTotalWeight() {
        this.totalWeight = 0.0f;
        this.dropmap.values().forEach(f -> this.totalWeight += f.floatValue());
    }

    private void handleDimBasedDrops(ModDimensionDef finalDef, int id) {
        if (id != ConfigHandler.ross128BID && id != ConfigHandler.ross128BAID) {
            if (id > 1 || id < -1) {
                this.getDropMapSpace(finalDef);
            } else {
                this.getDropMapVanilla();
            }
        }
    }

    private void handleModDimDef(int id) {
        Optional.ofNullable(this.makeModDimDef()).ifPresent(def -> {
            this.handleDimBasedDrops((ModDimensionDef)def, id);
            this.getDropMapBartworks((ModDimensionDef)def, id);
        });
    }

    private void calculateDropMap() {
        this.dropmap = new HashMap();
        int id = this.getBaseMetaTileEntity().getWorld().provider.dimensionId;
        this.handleModDimDef(id);
        this.handleExtraDrops(id);
        this.calculateTotalWeight();
    }

    private void makeDropMap() {
        if (this.dropmap == null || this.totalWeight == 0.0f) {
            this.calculateDropMap();
        }
    }

    private void handleOutputs() {
        Pair<Integer, Boolean> stats = this.getOreDamage();
        this.addOutput(new ItemStack(stats.getValue() != false ? WerkstoffLoader.BWOres : GregTech_API.sBlockOres1, this.multiplier, stats.getKey().intValue()));
        this.updateSlots();
    }

    static {
        GT_TileEntity_VoidMiner_Base.addMatierialToDimensionList(0, (ISubTagContainer)Materials.Tellurium, 8.0f);
    }
}

